from pyomo.environ import *
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import os
import pandas as pd

os.chdir("C:/Users/agusv/Desktop/Estudio/Tesis/Csv")

methodology=[]
total_truck_costs=[]
total_cooler_costs=[]
costs = []
truck_emissions = []
cooler_emissions = []
emissions = []
epsilons = []
truckquantities = []
coolerquantities = []

truck_type = ['Diesel_T', 'LNG_T', 'BioLNG_T', 'HVO100_T', 'Electric_T', 'Hydrogen_T']
cooler_type = ['Diesel_C', 'HVO100_C', 'Nitrogen_C','Electric_C']

truck_km = {
    'Diesel_T': 140000,
    'LNG_T': 130000,
    'BioLNG_T': 130000,
    'HVO100_T': 140000,
    'Electric_T': 70000,
    'Hydrogen_T': 100000
}

cooler_h = {
    'Diesel_C': 1896,
    'HVO100_C': 1896,
    'Nitrogen_C':1896,
    'Electric_C': 1896,
}

truck_costs = {
    'Diesel_T': 1.91,
    'LNG_T': 1.76,
    'BioLNG_T':1.8,
    'HVO100_T':1.95,
    'Electric_T':3.22,
    'Hydrogen_T':4.65
    }

cooler_costs = {
    'Diesel_C': 1.91,
    'HVO100_C':1.95,
    'Nitrogen_C': 1.875,
    'Electric_C':3.22
    }
    
truck_emissions_km = {
    "Diesel_T": 0.9956, 
    "LNG_T": 1.118,      
    "BioLNG_T": 0.209,  
    "HVO100_T": 0.3613,
    "Electric_T": 0.0874, 
    "Hydrogen_T": 0.0473 
}

cooler_emissions_h = {
    "Diesel_C": 12.744,
    "HVO100_C": 4.192,
    "Nitrogen_C": 6.072,
    "Electric_C": 0.2464
}

total_km=70000000
budget_azienda=131000000

#For the Single Objective Optimization the Epsilon value is 0 as it is not used in the function for this case.

epsilon_cost_so=0

#Single Objective Optimization for Costs Scenario C.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    
#As defined by the company manager.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['LNG_T']<=101)
    model.c10 = Constraint(expr=model.x['BioLNG_T']<=350)
    model.c11 = Constraint(expr=model.x['HVO100_T']<=350)
    model.c12 = Constraint(expr=model.x['Electric_T']<=26)
    model.c16 = Constraint(expr=model.x['Hydrogen_T']<=5)
    model.c13 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c14 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c15 = Constraint(expr=model.x['Electric_T']>=3)
    model.c16 = Constraint(expr=model.x['Hydrogen_T']<=5)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       

results_cost_so,truck_quantities_cost_so,cooler_quantities_cost_so,total_cost_truck_cost_so,total_cost_cooler_cost_so, total_cost_cost_so,total_emissions_cost_so,totalkm_cost_so,total_emissions_truck_cost_so,total_emissions_cooler_cost_so  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The final emissions value for the epsilon iteration is grabbed from the single optimization process.
single_cost_obj_emissions=total_emissions_cost_so

#Single Objective Optimization for Emissions

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + 
                          sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    
#As defined by the company manager.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['LNG_T']<=101)
    model.c10 = Constraint(expr=model.x['BioLNG_T']<=350)
    model.c11 = Constraint(expr=model.x['HVO100_T']<=350)
    model.c12 = Constraint(expr=model.x['Electric_T']<=26)
    model.c13 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c14 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c15 = Constraint(expr=model.x['Electric_T']>=3)
    model.c16 = Constraint(expr=model.x['Hydrogen_T']<=5)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       

results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)
methodology.append('Environmental Single Objective')
total_truck_costs.append(total_cost_truck)
total_cooler_costs.append(total_cost_cooler)
costs.append(total_cost)
truck_emissions.append(total_emissions_truck)
cooler_emissions.append(total_emissions_cooler)
emissions.append(total_emissions)
epsilons.append(epsilon_cost_so)
truckquantities.append(truck_quantities)
coolerquantities.append(cooler_quantities)


#The initial emissions value for the epsilon iteration is grabbed from the single optimization process.

single_env_obj_emissions=total_emissions

# Scenario C.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c2 = Constraint(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector)<=epsilon)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    
#As defined by the company manager.
    
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    model.c9 = Constraint(expr=model.x['LNG_T']<=101)
    model.c10 = Constraint(expr=model.x['BioLNG_T']<=350)
    model.c11 = Constraint(expr=model.x['HVO100_T']<=350)
    model.c12 = Constraint(expr=model.x['Electric_T']<=26)
    model.c13 = Constraint(expr=model.x['BioLNG_T']>=52)
    model.c14 = Constraint(expr=model.x['HVO100_T']>=5)
    model.c15 = Constraint(expr=model.x['Electric_T']>=3)
    model.c16 = Constraint(expr=model.x['Hydrogen_T']<=5)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler     


from matplotlib.ticker import ScalarFormatter
#5377006

epsilon_values = np.geomspace(single_env_obj_emissions, single_cost_obj_emissions, 50)

for epsilon in epsilon_values:
    results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
        epsilon, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
        truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
    )
    methodology.append('Multi Objective')
    total_truck_costs.append(total_cost_truck)
    total_cooler_costs.append(total_cost_cooler)
    costs.append(total_cost)
    truck_emissions.append(total_emissions_truck)
    cooler_emissions.append(total_emissions_cooler)
    emissions.append(total_emissions)
    epsilons.append(epsilon)
    truckquantities.append(truck_quantities)
    coolerquantities.append(cooler_quantities)

#After making the multi objective optimization the single economic objective optimization results are added to be graphed.

methodology.append('Economic Single Objective')
costs.append(total_cost_cost_so)
total_truck_costs.append(total_cost_truck_cost_so)
total_cooler_costs.append(total_cost_cooler_cost_so)
truck_emissions.append(total_emissions_truck_cost_so)
cooler_emissions.append(total_emissions_cooler_cost_so)
emissions.append(total_emissions_cost_so)
epsilons.append(epsilon_cost_so)
truckquantities.append(truck_quantities_cost_so)
coolerquantities.append(cooler_quantities_cost_so)

plt.figure(figsize=(12, 8))
colors = cm.RdYlGn_r(np.linspace(0, 1, len(epsilon_values)))
for i in range(len(epsilon_values)):
    plt.plot(emissions[i], costs[i], 'o', color=colors[i])

plt.plot(emissions, costs, linestyle='-', color='navy')

plt.xlabel('Total Emissions (Kg CO2e)', fontsize=20)
plt.ylabel('Total Cost (€)', fontsize=20)
plt.title('Pareto Frontier between Cost and Emissions', fontsize=20, fontweight='bold')

plt.gca().yaxis.set_major_formatter(ScalarFormatter())
plt.gca().xaxis.set_major_formatter(ScalarFormatter())
plt.gca().ticklabel_format(style="plain", axis="both")

plt.grid(True, linestyle='--', alpha=0.6)

plt.tight_layout()
plt.show()

#Plot truck types chosen

iterations = range(len(truckquantities))
truck_types = truck_type

truck_data = np.array([[iteration.get(truck, 0) for truck in truck_types] for iteration in truckquantities])


total_costs = costs

colors = cm.get_cmap("tab10", len(truck_types))

plt.figure(figsize=(12, 6))

for i, truck in enumerate(truck_types):
    plt.plot(iterations, truck_data[:, i], label=f"{truck}", color=colors(i))

budget_limit = 131000000
under_budget = True
start = 0

for i, total_cost in enumerate(total_costs):
    if total_cost > budget_limit and under_budget:
        # Mark under-budget region
        plt.axvspan(start, i, color="green", alpha=0.1, label="Under Budget" if start == 0 else "")
        under_budget = False
        start = i
    elif total_cost <= budget_limit and not under_budget:
        # Mark over-budget region
        plt.axvspan(start, i, color="red", alpha=0.1, label="Over Budget" if start == 0 else "")
        under_budget = True
        start = i

if under_budget:
    plt.axvspan(start, len(total_costs), color="green", alpha=0.1, label="Under Budget")
else:
    plt.axvspan(start, len(total_costs), color="red", alpha=0.1, label="Over Budget")

plt.title("Truck Quantities Across Iterations with Budget Constraint")
plt.xlabel("Iterations")
plt.ylabel("Number of Trucks")
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()

# Plot cooler types chosen

iterations = range(len(coolerquantities))
cooler_types = cooler_type

cooler_data = np.array([[iteration.get(cooler, 0) for cooler in cooler_types] for iteration in coolerquantities])

total_costs = costs

colors = cm.get_cmap("tab10", len(cooler_types))

plt.figure(figsize=(12, 6))

for i, cooler in enumerate(cooler_types):
    plt.plot(iterations, cooler_data[:, i], label=f"{cooler}", color=colors(i))

budget_limit = 131000000
under_budget = True
start = 0

for i, total_cost in enumerate(total_costs):
    if total_cost > budget_limit and under_budget:
        # Mark under-budget region
        plt.axvspan(start, i, color="green", alpha=0.1, label="Under Budget" if start == 0 else "")
        under_budget = False
        start = i
    elif total_cost <= budget_limit and not under_budget:
        # Mark over-budget region
        plt.axvspan(start, i, color="red", alpha=0.1, label="Over Budget" if start == 0 else "")
        under_budget = True
        start = i

if under_budget:
    plt.axvspan(start, len(total_costs), color="green", alpha=0.1, label="Under Budget")
else:
    plt.axvspan(start, len(total_costs), color="red", alpha=0.1, label="Over Budget")

plt.title("Cooler Quantities Across Iterations with Budget Constraint")
plt.xlabel("Iterations")
plt.ylabel("Number of Coolers")
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()

plt.figure(figsize=(10, 6))
iterations = range(1, len(costs) + 1)

plt.plot(iterations, costs, label="Total Cost",  linestyle='-', color='blue')
plt.plot(iterations, total_truck_costs, label="Total Truck Cost", linestyle='--', color='green')
plt.plot(iterations, total_cooler_costs, label="Total Cooler Cost", linestyle='-.', color='red')

plt.xlabel("Iteration", fontsize=12)
plt.ylabel("Cost (€)", fontsize=12)
plt.title("Cost Comparison Across Iterations", fontsize=14)
plt.legend(fontsize=10)
plt.grid(True, linestyle='--', alpha=0.7)

plt.tight_layout()
plt.show()

# Plotting the emissions per iteration
plt.figure(figsize=(10, 6))
iterations = range(1, len(emissions) + 1)

plt.plot(iterations, emissions, label="Total Emissions", linestyle='-', color='purple')
plt.plot(iterations, truck_emissions, label="Truck Emissions", linestyle='--', color='orange')
plt.plot(iterations, cooler_emissions, label="Cooler Emissions", linestyle='-.', color='magenta')

plt.xlabel("Iteration", fontsize=12)
plt.ylabel("Emissions (Kg CO2e)", fontsize=12)
plt.title("Emissions Comparison Across Iterations", fontsize=14)
plt.legend(fontsize=10)
plt.grid(True, linestyle='--', alpha=0.7)

plt.tight_layout()
plt.show()

